package easik.ui.tree.popup;

import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.util.ArrayList;

import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultMutableTreeNode;

import easik.Easik;
import easik.sketch.attribute.EntityAttribute;
import easik.sketch.attribute.UniqueKey;
import easik.sketch.attribute.UniqueKeyUI;
import easik.sketch.vertex.EntityNode;


/**
 * Add unique key popup menu action for the information tree.
 * 
 * @author Kevin Green 2006
 * @since 2006-06-14 Kevin Green
 * @version 2006-07-26 Kevin Green
 */
public class AddUniqueKeyAction extends AbstractAction {	
	
	/**
	 *	Set up the add unqiue key menu option.
	 */
	public AddUniqueKeyAction() {
		super("Add Unique Key");
		putValue( AbstractAction.SHORT_DESCRIPTION,  "Add a unique key to the currently selected entity.");		
	}
	
	/**
	 * Inserts a unique key to the currently selected entity
	 * @param e The action event
	 */
	public void actionPerformed(ActionEvent e ) {
		//If there is nothing seleceted then just do nothing
		if(Easik.getInstance().getFrame().getInfoTreeUI().getInfoTree().isSelectionEmpty())
		{
			return;
		}
		
		//Get currently selected object
		DefaultMutableTreeNode curSelectedNode = (DefaultMutableTreeNode) 
					Easik.getInstance().getFrame().getInfoTreeUI().getInfoTree().getSelectionPath().getLastPathComponent();
		Object curSelected = curSelectedNode.getUserObject();
		EntityNode curEntity;
		DefaultMutableTreeNode entityNode;
		
		//Check what is currently selected
		if(curSelected.getClass() == EntityNode.class){
			//Entity is selected so set it as current entity
			entityNode = (DefaultMutableTreeNode) curSelectedNode;
			curEntity = (EntityNode) curSelected;
		}
		else if(curSelected.getClass() == EntityAttribute.class){
			//An attribute is selected so get its parent entity
			entityNode = (DefaultMutableTreeNode) curSelectedNode.getParent();
			curEntity = (EntityNode) entityNode.getUserObject();
		}
		else{
			JOptionPane.showMessageDialog(Easik.getInstance().getFrame(), 
					"You do not have an entity selected. \nPlease select an entity and try again.",
					"No Entity Selected", JOptionPane.ERROR_MESSAGE);
			return;//Jump out of function
		}
		
		//If the entity does not contain any attirbutes
		if(curEntity.getAttributes().size() == 0){
			//Pop up error dialog
			JOptionPane.showMessageDialog(Easik.getInstance().getFrame(), 
					"There are no attributes associated with this entity. \nPlease add attributes and try again.",
					"No Attributes Exist", JOptionPane.ERROR_MESSAGE);
			return;//Jump out of function
		}
		
		UniqueKeyUI myUI = new UniqueKeyUI(curEntity);
		if(myUI.getExit())
		{
			//Get values from dialog
			String newKeyName = myUI.getKeyName();
			ArrayList newAttList = myUI.getAttList();
			
			//If no attributes selected
			if(newAttList.size() == 0){
				//Pop up error dialog
				JOptionPane.showMessageDialog(Easik.getInstance().getFrame(), 
						"You have no attributes selected to be part of the key. \nPlease try again.",
						"No Attributes Selected", JOptionPane.ERROR_MESSAGE);
				return;//Jump out of function
			}
			
			UniqueKey newKey = new UniqueKey(curEntity, newAttList, newKeyName);
			
			//Check if attribute name already exists for this entity
			if(!UniqueKey.isKeyNameUsed(curEntity, newKeyName) && UniqueKey.isKeyUnique(curEntity, newKey.getId())){
				//Create new unique key
				curEntity.addUniqueKey(newKey);
				
				//Create new node for unique key
				DefaultMutableTreeNode keyNode = new DefaultMutableTreeNode(newKey);
				newKey.setNode(keyNode);
				
				//Add unique key to tree
				curEntity.getKeyNode().add(keyNode);
				curEntity.testKeysNode();
				Easik.getInstance().getFrame().getInfoTreeUI().refreshTree(curEntity.getNode()); //Refresh view of entity keys
				
				Object[] myCell = new Object[1];
				myCell[0] = Easik.getInstance().getFrame().getSketch().getAdapter().getVertexCell(curEntity);
				Easik.getInstance().getFrame().getSketch().getGraphLayoutCache().hideCells(myCell, true);
				Easik.getInstance().getFrame().getSketch().getGraphLayoutCache().showCells(myCell, true);
				Easik.getInstance().getFrame().getSketch().repaint();
				
				Easik.getInstance().getFrame().getSketch().setDirty(true);
			}
			else{
				//Pop up error dialog
				JOptionPane.showMessageDialog(Easik.getInstance().getFrame(), 
						"There is already a unique key with that name or attribute list. \nPlease try again.",
						"Unique Key Already Exists", JOptionPane.ERROR_MESSAGE);
			}
		}
	}
}
